<?php 
    /**
    *
    * copyright (c) 2013-2022 Heliac Technologies
    * license http://opensource.org/licenses/gpl-license.php GNU GPL v3 
    *
    * linee guida per l'utilizzo del logo http://www.geecom.org/articolo.php?id=34&alias=linee-guida-per-l%27uso-del-logo-geecom
    */

    include "include/includeBase.php";
    
    include "include/controlloLogin.php";
    
    $elementiPerPagina = isset($_GET["elementiPerPagina"]) ? filter_input(INPUT_GET,"elementiPerPagina",FILTER_SANITIZE_NUMBER_INT) : 25;
    $cerca             = isset($_GET["cerca"]) ? filter_input(INPUT_GET,"cerca",FILTER_SANITIZE_STRING) : "";

    $parametriRicerca = $cerca!="" ? array("prodotto"=>"Doc","testo"=>$cerca) : array("prodotto"=>"Doc");
    $parametri = array("tabella"=>"geec_notifiche", "elementiPerPagina"=>$elementiPerPagina,"parametriRicerca"=>$parametriRicerca,"ajax"=>false);

    $ricerca = new Ricerca($geecomDb, $parametri, $impostazioniRicerca,"notifiche.php");
?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <title>Amministrazione di Geecom Doc - notifiche</title>

    <?php
        include "include/cssBaseAreaAmministrativa.php";
    ?>
</head>

<body>
   
    <!-- barra superiore -->
    <?php  
        include "include/barraSuperiore.php";

        include "include/header.php";

        include "include/barraMenu.php";
    ?>
    <!-- /riga menu principale -->
    
    <div class="modal fade" id="modalEliminaNotifica" tabindex="-1" role="dialog" aria-labelledby="modifica componente intestazione" aria-hidden="true">
        <div class="modal-dialog modal-lg" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Eliminare la notifica?</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Chiudi">
                    <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <div class="d-flex flex-row justify-content-center">
                        <div class="align-self-center text-center">
                            <span class="align-self-center text-primary"><em id="nomePaginaDaEliminare"></em></span>
                            <div id="tipoElementoDaEliminare"></div>
                        </div>
                    </div>
                    <input type="text" class="d-none" id="paginaDaEliminare">
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-outline-primary btn-sm" data-dismiss="modal"><i class="fas fa-times"></i> Annulla</button>
                    <button type="button" class="btn btn-primary btn-sm" onclick="eseguiEliminazioneNotifica()"><i class="fas fa-check"></i> Elimina</button>
                </div>
            </div>
        </div>
    </div>
    
    <main role="main" class="bg-light" id="main">
        <div class="container-fluid">
            <div id="contenutoPrincipale" class="row">
                <div class="col py-4">
                    <div class="card mb-4 box-shadow-lite">
                        <div class="panel panel-default">
                            
                            <div class="card-body collapse show">
                                <div class="d-flex justify-content-between mb-3">
                                    <?php
                                        $ricerca->stampaSelectNumeroElementi($cerca);
                                        $ricerca->stampaFormRicerca($cerca);
                                    ?>
                                </div>
                                <div class="table-responsive p-1">
                                    <table id="example" class="table table-striped table-hover" style="width:100%">
                                        <thead>
                                            <tr>
                                                <th>ID</th>
                                                <th>Testo</th>
                                                <th>Letta</th>
                                                <th>Data</th>
                                                <th>Azioni</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                        <?php
                                       
                                            if(isset($_GET["pag"])) {
                                                $ricerca->eseguiRicerca($_GET["pag"]);
                                            }
                                            else {
                                                $ricerca->eseguiRicerca(1);
                                            }

                                            $result = $ricerca->getRisultatoQueryRicerca();
                                            while($notifica=$result->fetch_assoc()) {
                                                $dataCreazione = date("d/m/Y",strtotime($notifica["dataCreazione"]));
                                                echo"<tr id=\"notifica{$notifica["id"]}\">
                                                <td>{$notifica["id"]}</td>
                                                <td>{$notifica["testo"]}</td>
                                                <td>{$notifica["letta"]}</td>
                                                <td>{$dataCreazione}</td>
                                                <td><div class=\"btn-group azioni\" role=\"group\" aria-label=\"Azioni\">
                                                    <a  class=\"btn elimina\" href=\"#\" onclick=\"eliminaNotifica({$notifica["id"]},'{$notifica["testo"]}')\" data-toggle=\"tooltip\" data-placement=\"bottom\" title=\"Elimina\"><i class=\"far fa-trash-alt\"></i> </a>";
                                                echo"</div>
                                                    </td>
                                              </tr>";
                                            }
                                        ?>
                                        </tbody>
                                    </table>
                                </div>
                                <?php
                                    $ricerca->stampaPaginazione("gestioneAmministratori.php?pag=");
                                ?>
                            </div>
                            <!-- /tabella -->
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </main>
    
    <?php 
        include "include/footer.php";
                
        include "include/modal/cambiaPassword.php";
                
        include "include/modal/modalMenuComponenti.php";
                
        include "include/jsBaseAreaAmministrativa.php";
    ?>
	
    <script type="text/javascript">
        function eliminaNotifica(id,titoloPagina) {
            $('#paginaDaEliminare').val(id);
            $('#nomePaginaDaEliminare').html(titoloPagina);
            $('#modalEliminaNotifica').modal('show');
        }

        function eseguiEliminazioneNotifica() {
            var id = $('#paginaDaEliminare').val();
            $.ajax({
                type:"POST",
                url:"../controller/controllerNotifiche.php",
                data:{
                    operazione:"elimina",
                    id:id
                },
                success:function(result) {
                    if(result=="ok") {
                        document.getElementById("notifica"+id).className = "d-none";
                        $('#modalEliminaNotifica').modal('hide');
                    }
                },
                error: function() {
                    alert("Si sono verificato problemi durante la richiesta, riprova tra qualche istante");
                }
            });
        }
    </script>
</body>
</html>